class TDM_Mutator expands Mutator config(AdultSetup);

var config string 	TDMGameName,
			TDMLeftMessage,
			TDMEnteredMessage,
			RedTeamIcon,
			BlueTeamIcon,
			GreenTeamIcon,
			GoldTeamIcon;

function PreBeginPlay ()
{
	Super.PreBeginPlay();
	SaveConfig();

	Level.Game.ScoreBoardType = Class'TDM_SB';
	Level.Game.HUDType = Class'TDM_HUD';
	Level.Game.GameName = TDMGameName;
	Level.Game.LeftMessage = TDMLeftMessage;
	Level.Game.EnteredMessage = TDMEnteredMessage;

	AddMutator(Level.Spawn(class'TDM_StatsMutator'));
	AddMutator(Level.Spawn(class'AdultInventory'));
	AddMutator(Level.Spawn(class'IP2Country'));
	AddMutator(Level.Spawn(class'Revenge'));
	SetTimer(1.0,True);
}

function Timer()
{
local Pawn P;

	Super.Timer();

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			PRI(PlayerPawn(P).PlayerReplicationInfo).RedTeamIcon = RedTeamIcon;
			PRI(PlayerPawn(P).PlayerReplicationInfo).BlueTeamIcon = BlueTeamIcon;
			PRI(PlayerPawn(P).PlayerReplicationInfo).GreenTeamIcon = GreenTeamIcon;
			PRI(PlayerPawn(P).PlayerReplicationInfo).GoldTeamIcon = GoldTeamIcon;
			}
		}
}

function bool AlwaysKeep(Actor Other) 
{
	if (Other.IsA('Carcass'))
		{
		Carcass(Other).Style = STY_Translucent;
		Carcass(Other).bProjTarget = False;
		Carcass(Other).bBlockPlayers = False;
		}
	if (Other.IsA('Ammo') && !Other.IsA('WarHeadAmmo'))
		{
		Ammo(Other).AmmoAmount = Ammo(Other).default.AmmoAmount * 2;
		Ammo(Other).MaxAmmo = Ammo(Other).default.MaxAmmo * 10;
		}
	if (Other.IsA('GooGun'))
		{
		GooGun(Other).MultiSkins[1]=Texture'GooGunSkinA';
		GooGun(Other).MultiSkins[3]=Texture'GooGunSkinB';
		}
	if (Other.IsA('BukkakeGun'))
		{
		BukkakeGun(Other).MultiSkins[1]=Texture'BukkakeGunSkinA';
		BukkakeGun(Other).MultiSkins[3]=Texture'BukkakeGunSkinB';
		BukkakeGun(Other).MultiSkins[0]=Texture'BukkakeGunSkinC';
		}

	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));
	
	return false;
}

defaultproperties
{
TDMGameName="Adult Team DeathMatch"
TDMLeftMessage=" is a quitter!!!"
TDMEnteredMessage=" joined the action!"
}
